package gov.va.med.mhv.usermgmt.data.repository;


import java.util.List;

import gov.va.med.mhv.common.data.model.FacilityPreference;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface FacilityPreferenceRepository extends JpaRepository<FacilityPreference, Long>{


	@Query("select pref from FacilityPreference pref where pref.patientId= :patientId")
	 List<FacilityPreference> getFacilityPreferenceByPatientId (@Param("patientId") Long patientId);
	
	 @Modifying
	 @Transactional
	 @Query("Delete from FacilityPreference pref where pref.patientId= :patientId")
	 void deleteFacilityPrefereneceByPatientId(@Param("patientId") Long patientId);
}
